/*
 * Decompiled with CFR 0.152.
 */
package com.google.scrollview.ui;

import com.google.scrollview.ScrollView;
import com.google.scrollview.events.SVEvent;
import com.google.scrollview.events.SVEventHandler;
import com.google.scrollview.events.SVEventType;
import com.google.scrollview.ui.SVMenuBar;
import com.google.scrollview.ui.SVPopupMenu;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TextArea;
import java.awt.event.KeyListener;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.extras.swing.PScrollPane;
import org.piccolo2d.nodes.PImage;
import org.piccolo2d.nodes.PPath;
import org.piccolo2d.nodes.PText;

public class SVWindow
extends JFrame {
    private static final int MAX_WINDOW_X = 1000;
    private static final int MAX_WINDOW_Y = 800;
    private static final int DEF_MESSAGEBOX_HEIGHT = 200;
    public static final double SCALING_FACTOR = 2.0;
    PLayer layer;
    Color currentPenColor;
    Color currentBrushColor;
    Font currentFont;
    BasicStroke stroke = new BasicStroke(0.5f);
    public int hash;
    public static int nrWindows = 0;
    private SVEventHandler svEventHandler = null;
    private SVMenuBar svMenuBar = null;
    private TextArea ta = null;
    public SVPopupMenu svPuMenu = null;
    public PCanvas canvas;
    private int winSizeX;
    private int winSizeY;

    public void brush(int n, int n2, int n3) {
        this.brush(n, n2, n3, 255);
    }

    public void brush(int n, int n2, int n3, int n4) {
        this.currentBrushColor = n4 == 0 ? null : new Color(n, n2, n3, n4);
    }

    public void clear() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVWindow.this.layer.removeAllChildren();
                SVWindow.this.repaint();
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void createPolyline(int n) {
        ScrollView.polylineXCoords = new float[n];
        ScrollView.polylineYCoords = new float[n];
        ScrollView.polylineSize = n;
        ScrollView.polylineScanned = 0;
    }

    public void drawPolyline() {
        int n = ScrollView.polylineXCoords.length;
        if (n < 2) {
            return;
        }
        PPath pPath = PPath.createLine((float)ScrollView.polylineXCoords[0], (float)ScrollView.polylineYCoords[0], (float)ScrollView.polylineXCoords[1], (float)ScrollView.polylineYCoords[1]);
        pPath.reset();
        pPath.moveTo((double)ScrollView.polylineXCoords[0], (double)ScrollView.polylineYCoords[0]);
        for (int i = 1; i < n; ++i) {
            pPath.lineTo((double)ScrollView.polylineXCoords[i], (double)ScrollView.polylineYCoords[i]);
        }
        pPath.closePath();
        ScrollView.polylineSize = 0;
        pPath.setStrokePaint((Paint)this.currentPenColor);
        pPath.setPaint(null);
        pPath.setStroke((Stroke)this.stroke);
        this.layer.addChild((PNode)pPath);
    }

    public SVWindow(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(string);
        if (n4 == 0) {
            n4 = n6;
        }
        if (n5 == 0) {
            n5 = n7;
        }
        if (n6 == 0) {
            n6 = n4;
        }
        if (n7 == 0) {
            n7 = n5;
        }
        ++nrWindows;
        this.hash = n;
        this.svEventHandler = new SVEventHandler(this);
        this.currentPenColor = Color.BLACK;
        this.currentBrushColor = Color.BLACK;
        this.currentFont = new Font("Times New Roman", 0, 12);
        int n8 = 1;
        if (n4 > 1000) {
            n8 = (n4 + 1000 - 1) / 1000;
        }
        if (n5 / n8 > 800) {
            n8 = (n5 + 800 - 1) / 800;
        }
        this.winSizeX = n4 / n8;
        this.winSizeY = n5 / n8;
        double d = 1.0 / (double)n8;
        if (this.winSizeX > n6 || this.winSizeY > n7) {
            d = Math.min(1.0 * (double)this.winSizeX / (double)n6, 1.0 * (double)this.winSizeY / (double)n7);
        }
        if (this.canvas == null) {
            this.canvas = new PCanvas();
            this.getContentPane().add((Component)this.canvas, "Center");
        }
        this.layer = this.canvas.getLayer();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setDefaultRenderQuality(0);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.validate();
        this.canvas.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVWindow.this.repaint();
            }
        });
        this.setSize(this.winSizeX, this.winSizeY);
        this.setLocation(n2, n3);
        this.setTitle(string);
        PScrollPane pScrollPane = new PScrollPane((Component)this.canvas);
        this.getContentPane().add((Component)pScrollPane);
        pScrollPane.setWheelScrollingEnabled(false);
        PCamera pCamera = this.canvas.getCamera();
        pCamera.scaleViewAboutPoint(d, 0.0, 0.0);
        this.addWindowListener(this.svEventHandler);
        this.canvas.removeInputEventListener((PInputEventListener)this.canvas.getPanEventHandler());
        this.canvas.removeInputEventListener((PInputEventListener)this.canvas.getZoomEventHandler());
        this.canvas.addInputEventListener((PInputEventListener)this.svEventHandler);
        this.canvas.addKeyListener((KeyListener)this.svEventHandler);
        this.validate();
        this.setVisible(true);
    }

    public void addMessageBox() {
        if (this.ta == null) {
            this.ta = new TextArea();
            this.ta.setEditable(false);
            this.getContentPane().add((Component)this.ta, "South");
        }
        this.winSizeY += 200;
        this.setSize(this.winSizeX, this.winSizeY);
    }

    public void setStrokeWidth(float f) {
        this.stroke = new BasicStroke(f);
    }

    public void drawEllipse(int n, int n2, int n3, int n4) {
        PPath pPath = PPath.createEllipse((float)n, (float)n2, (float)n3, (float)n4);
        pPath.setStrokePaint((Paint)this.currentPenColor);
        pPath.setStroke((Stroke)this.stroke);
        pPath.setPaint((Paint)this.currentBrushColor);
        this.layer.addChild((PNode)pPath);
    }

    public void drawImage(PImage pImage, int n, int n2) {
        pImage.setX((double)n);
        pImage.setY((double)n2);
        this.layer.addChild((PNode)pImage);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        PPath pPath = PPath.createLine((float)n, (float)n2, (float)n3, (float)n4);
        pPath.setStrokePaint((Paint)this.currentPenColor);
        pPath.setPaint(null);
        pPath.setStroke((Stroke)this.stroke);
        pPath.moveTo((double)n, (double)n2);
        pPath.lineTo((double)n3, (double)n4);
        this.layer.addChild((PNode)pPath);
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n;
            n = n3;
            n3 = n5;
        }
        if (n2 > n4) {
            n5 = n2;
            n2 = n4;
            n4 = n5;
        }
        PPath pPath = PPath.createRectangle((float)n, (float)n2, (float)(n3 - n), (float)(n4 - n2));
        pPath.setStrokePaint((Paint)this.currentPenColor);
        pPath.setStroke((Stroke)this.stroke);
        pPath.setPaint((Paint)this.currentBrushColor);
        this.layer.addChild((PNode)pPath);
    }

    public void drawText(int n, int n2, String string) {
        int n3 = -1;
        char[] cArray = string.toCharArray();
        PText pText = new PText(string);
        pText.setTextPaint((Paint)this.currentPenColor);
        pText.setFont(this.currentFont);
        for (int i = 0; i < cArray.length; ++i) {
            if (this.currentFont.canDisplay(cArray[i])) continue;
            n3 = i;
            break;
        }
        if (n3 != -1) {
            Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int i = 0; i < fontArray.length; ++i) {
                if (!fontArray[i].canDisplay(cArray[n3])) continue;
                Font font = new Font(fontArray[i].getFontName(), this.currentFont.getStyle(), this.currentFont.getSize());
                pText.setFont(font);
                break;
            }
        }
        pText.setX((double)n);
        pText.setY((double)n2);
        this.layer.addChild((PNode)pText);
    }

    public void pen(int n, int n2, int n3) {
        this.pen(n, n2, n3, 255);
    }

    public void pen(int n, int n2, int n3, int n4) {
        this.currentPenColor = new Color(n, n2, n3, n4);
    }

    public void textAttributes(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        if (string.equals("Times")) {
            string = "Times New Roman";
        }
        int n2 = 0;
        if (bl) {
            ++n2;
        }
        if (bl2) {
            n2 += 2;
        }
        this.currentFont = new Font(string, n2, n);
    }

    public void zoomRectangle(int n, int n2, int n3, int n4) {
        if (n3 > n && n4 > n2) {
            this.winSizeX = this.getWidth();
            this.winSizeY = this.getHeight();
            int n5 = n3 - n;
            int n6 = n4 - n2;
            int n7 = n5 / 2;
            int n8 = n6 / 2;
            double d = Math.min((double)this.winSizeX / (2.0 * (double)n7 + (double)n5), (double)this.winSizeY / (2.0 * (double)n8 + (double)n6));
            PCamera pCamera = this.canvas.getCamera();
            pCamera.scaleView(d / pCamera.getViewScale());
            pCamera.animateViewToPanToBounds((Rectangle2D)new Rectangle(n - n8, n2 - n8, 2 * n7 + n5, 2 * n8 + n6), 0L);
        }
    }

    public void update() {
        try {
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalPathStateException illegalPathStateException) {
            // empty catch block
        }
    }

    public void addMenuBarItem(String string, String string2, int n, boolean bl) {
        this.svMenuBar.add(string, string2, n, bl);
    }

    public void addMenuBarItem(String string, String string2) {
        this.addMenuBarItem(string, string2, -1);
    }

    public void addMenuBarItem(String string, String string2, int n) {
        if (this.svMenuBar == null) {
            this.svMenuBar = new SVMenuBar(this);
        }
        this.svMenuBar.add(string, string2, n);
    }

    public void addMessage(String string) {
        if (this.ta != null) {
            this.ta.append(string + "\n");
        } else {
            System.out.println(string + "\n");
        }
    }

    private static String convertIntegerStringToUnicodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Pattern pattern = Pattern.compile("0x[0-9a-fA-F]{4}");
        Matcher matcher = pattern.matcher(stringBuffer);
        while (matcher.find()) {
            char c = (char)Integer.decode(matcher.group()).intValue();
            stringBuffer.replace(matcher.start(), matcher.end(), String.valueOf(c));
            matcher.reset();
        }
        return stringBuffer.toString();
    }

    public void showInputDialog(String string, String string2, int n, SVEventType sVEventType) {
        this.svEventHandler.timer.stop();
        String string3 = (String)JOptionPane.showInputDialog(this, string, "", 3, null, null, string2);
        if (string3 != null) {
            string3 = SVWindow.convertIntegerStringToUnicodeString(string3);
            SVEvent sVEvent = new SVEvent(sVEventType, this, n, string3);
            ScrollView.addMessage(sVEvent);
        }
        this.svEventHandler.timer.restart();
    }

    public void showInputDialog(String string) {
        this.showInputDialog(string, null, -1, SVEventType.SVET_INPUT);
    }

    public void showYesNoDialog(String string) {
        int n = JOptionPane.showOptionDialog(this, string, "", 0, 3, null, null, null);
        SVEvent sVEvent = null;
        if (n == 0) {
            sVEvent = new SVEvent(SVEventType.SVET_INPUT, this, 0, 0, 0, 0, "y");
        } else if (n == 1) {
            sVEvent = new SVEvent(SVEventType.SVET_INPUT, this, 0, 0, 0, 0, "n");
        }
        ScrollView.addMessage(sVEvent);
    }

    public void addPopupMenuItem(String string, String string2) {
        if (this.svPuMenu == null) {
            this.svPuMenu = new SVPopupMenu(this);
        }
        this.svPuMenu.add(string, string2, -1);
    }

    public void addPopupMenuItem(String string, String string2, int n, String string3, String string4) {
        if (this.svPuMenu == null) {
            this.svPuMenu = new SVPopupMenu(this);
        }
        this.svPuMenu.add(string, string2, n, string3, string4);
    }

    public void destroy() {
        ScrollView.addMessage(new SVEvent(SVEventType.SVET_DESTROY, this, 0, "SVET_DESTROY"));
        this.setVisible(false);
    }
}

