VERSION 5.00
Begin VB.Form frmDemo 
   Caption         =   "Shape Demonstration"
   ClientHeight    =   6675
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6645
   LinkTopic       =   "Form1"
   ScaleHeight     =   6675
   ScaleWidth      =   6645
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   6
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   36
      TabStop         =   0   'False
      Top             =   3000
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   7
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   35
      TabStop         =   0   'False
      Top             =   3450
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   11
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   34
      TabStop         =   0   'False
      Top             =   5700
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   10
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   33
      TabStop         =   0   'False
      Top             =   5250
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   9
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   32
      TabStop         =   0   'False
      Top             =   4800
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   8
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   31
      TabStop         =   0   'False
      Top             =   4350
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   2
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   24
      TabStop         =   0   'False
      Top             =   4350
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   3
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   23
      TabStop         =   0   'False
      Top             =   4800
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   4
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   22
      TabStop         =   0   'False
      Top             =   5250
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   5
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   21
      TabStop         =   0   'False
      Top             =   5700
      Width           =   1455
   End
   Begin VB.TextBox txtConstrained 
      Height          =   375
      Index           =   0
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   19
      TabStop         =   0   'False
      Top             =   2100
      Width           =   1455
   End
   Begin VB.TextBox txtConstrained 
      Height          =   375
      Index           =   1
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   18
      TabStop         =   0   'False
      Top             =   2100
      Width           =   1455
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   360
      Left            =   5040
      TabIndex        =   17
      Top             =   6225
      Width           =   1155
   End
   Begin VB.CommandButton cmdRequery 
      Caption         =   "&Requery"
      Height          =   360
      Left            =   3720
      TabIndex        =   16
      Top             =   6225
      Width           =   1155
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   1
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3450
      Width           =   1455
   End
   Begin VB.TextBox txtTime 
      Height          =   375
      Index           =   0
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   11
      TabStop         =   0   'False
      Top             =   3000
      Width           =   1455
   End
   Begin VB.TextBox txtPublishers 
      Height          =   375
      Index           =   1
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   750
      Width           =   1455
   End
   Begin VB.TextBox txtTitles 
      Height          =   375
      Index           =   1
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   1200
      Width           =   1455
   End
   Begin VB.TextBox txtUnconstrained 
      Height          =   375
      Index           =   1
      Left            =   4560
      Locked          =   -1  'True
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   1650
      Width           =   1455
   End
   Begin VB.TextBox txtUnconstrained 
      Height          =   375
      Index           =   0
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   1650
      Width           =   1455
   End
   Begin VB.TextBox txtTitles 
      Height          =   375
      Index           =   0
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   1200
      Width           =   1455
   End
   Begin VB.TextBox txtPublishers 
      Height          =   375
      Index           =   0
      Left            =   2700
      Locked          =   -1  'True
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   750
      Width           =   1455
   End
   Begin VB.Label Label9 
      Alignment       =   2  'Center
      Caption         =   "Total"
      Height          =   255
      Left            =   4560
      TabIndex        =   37
      Top             =   2700
      Width           =   1455
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      Caption         =   "Query"
      Height          =   255
      Left            =   2700
      TabIndex        =   30
      Top             =   2700
      Width           =   1455
   End
   Begin VB.Label Label16 
      Alignment       =   1  'Right Justify
      Caption         =   "Unconstrained"
      Height          =   255
      Left            =   840
      TabIndex        =   29
      Top             =   4425
      Width           =   1800
   End
   Begin VB.Label Label15 
      Alignment       =   1  'Right Justify
      Caption         =   "Parameterized"
      Height          =   255
      Left            =   840
      TabIndex        =   28
      Top             =   4875
      Width           =   1800
   End
   Begin VB.Label Label14 
      Alignment       =   1  'Right Justify
      Caption         =   "Inner Join"
      Height          =   255
      Left            =   840
      TabIndex        =   27
      Top             =   5325
      Width           =   1800
   End
   Begin VB.Label Label13 
      Alignment       =   1  'Right Justify
      Caption         =   "IN Clause"
      Height          =   255
      Left            =   840
      TabIndex        =   26
      Top             =   5775
      Width           =   1800
   End
   Begin VB.Label Label12 
      Caption         =   "Times (Constrained Parent):"
      Height          =   255
      Left            =   360
      TabIndex        =   25
      Top             =   4050
      Width           =   2200
   End
   Begin VB.Label Label11 
      Alignment       =   1  'Right Justify
      Caption         =   "Constrained Parent Query"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   2175
      Width           =   2505
   End
   Begin VB.Label Label10 
      Caption         =   "Times (Unconstrained Parent):"
      Height          =   255
      Left            =   360
      TabIndex        =   15
      Top             =   2700
      Width           =   2200
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      Caption         =   "Constrained Subquery"
      Height          =   255
      Left            =   840
      TabIndex        =   14
      Top             =   3525
      Width           =   1800
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      Caption         =   "Unconstrained Subquery"
      Height          =   255
      Left            =   840
      TabIndex        =   12
      Top             =   3075
      Width           =   1800
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Constrained Subquery"
      Height          =   465
      Left            =   4560
      TabIndex        =   10
      Top             =   225
      Width           =   1455
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Unconstrained Subquery"
      Height          =   465
      Left            =   2700
      TabIndex        =   9
      Top             =   225
      Width           =   1455
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Unconstrained Parent Query"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   1725
      Width           =   2505
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Titles"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   1275
      Width           =   2505
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Publishers"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   810
      Width           =   2505
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Copyright 1999, InStep Technologies, Inc.
'All rights reserved.

'This is a demonstration of
'1) How to use hierarchical recordsets, using SHAPE; and
'2) A gotcha using SHAPE whereby an unconstrained
'   subquery will return accurate results, but returns
'   unnecessary records, resulting in poor performance.

Private Const iPARENT_UNCONSTRAINED = 0
Private Const iPARENT_CONSTRAINED = 1

Private Const iU_UNCONSTRAINED = 0
Private Const iU_CONSTRAINED = 1
Private Const iC_UNCONSTRAINED = 2
Private Const iC_PARAMETER = 3
Private Const iC_JOIN = 4
Private Const iC_IN_CLAUSE = 5
Private Const iOFFSET_TOTAL = 6

Option Explicit

Private Sub QueryData()
Dim oConnect As New ADODB.Connection
Dim oRS As New ADODB.Recordset
Dim sConnect As String
Dim sSQL As String
Dim sFileName As String
Dim vChildSet As Variant
Dim lCount As Long
Dim lStart As Long

   Me.Show
   DoEvents

   Screen.MousePointer = vbHourglass
   
   'Edit this line to point to your
   'version of the Biblio.mdb
   sFileName = "D:\Program Files\" & _
      "Microsoft Visual Studio\VB98\Biblio.mdb"

   'SHAPE queries require the 'MSDataShape' provider.
   'Note that when you use 'MSDataShape' as the provider,
   'you need to separately specify the Data Provider.
   'Note also, you can still do normal queries even
   'with 'MSDataShape' as the provider
   sConnect = "Data Source = " & sFileName & "; " & _
      "Provider = MSDataShape; " & _
      "Data Provider = Microsoft.Jet.OLEDB.3.51; "
   oConnect.Open sConnect
      
   With oRS
      Set .ActiveConnection = oConnect
      .CursorLocation = adUseClient
      .CursorType = adOpenForwardOnly
      .LockType = adLockReadOnly
      
      'get total publisher count
      .Source = "SELECT * FROM Publishers"
      .Open
      .MoveLast
      txtPublishers(iPARENT_UNCONSTRAINED).Text = oRS.RecordCount
      .Close
      
      'get constrained publisher count
      .Source = "SELECT * FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%'"
      .Open
      .MoveLast
      txtPublishers(iPARENT_CONSTRAINED).Text = oRS.RecordCount
      .Close
      
      'get total title counts
      .Source = "SELECT * FROM Titles"
      .Open
      .MoveLast
      txtTitles(iPARENT_UNCONSTRAINED).Text = oRS.RecordCount
      .Close
      
      'get constrained title counts
      .Source = "SELECT * FROM Titles " & _
         "WHERE PubID IN " & _
         "(SELECT PubID " & _
         "FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%')"
      .Open
      .MoveLast
      txtTitles(iPARENT_CONSTRAINED).Text = oRS.RecordCount
      .Close
      
      Me.Refresh
      
      '**************************
      'Now for the SHAPE queries
      '**************************
      
      'Note the general format of the shape command:
      'SHAPE {[Parent Query]} APPEND ({[Child Query]} AS [Alias]
      'RELATE [Parent Field] to [Child Field])
      
      'Also note that the required delimiters surrounding the
      'two queries are curly brackets, not parentheses
      
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%'} AS Pubs " & _
         "APPEND " & _
         "({SELECT * FROM Titles} AS Books " & _
         "RELATE 'PubID' to 'PubID')"
      
      lStart = GetTickCount
      .Open
      txtTime(iC_UNCONSTRAINED).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      
      'Scroll through the parent recordset, and sum up the counts
      'of the children records to ensure the correct data is being returned
      While Not .EOF
         'this is how child recordsets are referenced, via
         'a reference to a field in the parent recordset
         'which assumes the aleas name given to it in the query
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            'uncomment this line to see how to access child field values
            'Debug.Print vChildSet.Fields("Title").Value
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         vChildSet = Empty
         .MoveNext
      Wend
      txtTime(iC_UNCONSTRAINED + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtConstrained(iPARENT_UNCONSTRAINED).Text = lCount
      .Close
      
      
      'This query constrains the child recordset
      'by joining the same table and constraint
      'as are in the parent recordset
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%'} AS Pubs " & _
         "APPEND " & _
         "({SELECT Titles.* FROM Titles " & _
         "INNER JOIN Publishers " & _
         "ON Titles.PubID = Publishers.PubID " & _
         "WHERE [Company Name] LIKE 'J%'} AS Books " & _
         "RELATE 'PubID' to 'PubID')"
      lStart = GetTickCount
      .Open
      txtTime(iC_JOIN).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      lCount = 0
      While Not .EOF
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         vChildSet = Empty
         .MoveNext
      Wend
      txtTime(iC_JOIN + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtConstrained(iPARENT_CONSTRAINED).Text = lCount
      .Close
         
      'This works, too, by using
      'a parameterized child query
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%'} AS Pubs " & _
         "APPEND " & _
         "({SELECT * FROM Titles " & _
         "WHERE PubID = ?} AS Books " & _
         "RELATE 'PubID' to PARAMETER 0)"
      lStart = GetTickCount
      .Open
      txtTime(iC_PARAMETER).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      lCount = 0
      While Not .EOF
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         vChildSet = Empty
         .MoveNext
      Wend
      txtTime(iC_PARAMETER + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtConstrained(iPARENT_CONSTRAINED).Text = lCount
      .Close
         
      'This works, too, by using an IN clause
      'to restrain the child query
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%'} AS Pubs " & _
         "APPEND " & _
         "({SELECT * FROM Titles " & _
         "WHERE PubID IN " & _
         "(SELECT PubID " & _
         "FROM Publishers " & _
         "WHERE [Company Name] LIKE 'J%')} AS Books " & _
         "RELATE 'PubID' to 'PubID')"
      lStart = GetTickCount
      .Open
      txtTime(iC_IN_CLAUSE).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      lCount = 0
      While Not .EOF
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         vChildSet = Empty
         .MoveNext
      Wend
      txtTime(iC_IN_CLAUSE + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtConstrained(iPARENT_CONSTRAINED).Text = lCount
      .Close
      
      'What happens if the parent query is unconstrained?
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers} AS Pubs " & _
         "APPEND " & _
         "({SELECT * FROM Titles} AS Books " & _
         "RELATE 'PubID' to 'PubID')"
      
      Me.Refresh
      
      lStart = GetTickCount
      .Open
      txtTime(iU_UNCONSTRAINED).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      lCount = 0
      While Not .EOF
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         vChildSet = Empty
         .MoveNext
      Wend
      txtTime(iU_UNCONSTRAINED + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtUnconstrained(iPARENT_UNCONSTRAINED).Text = lCount
      .Close
   
      .Source = "SHAPE " & _
         "{SELECT * FROM Publishers} AS Pubs " & _
         "APPEND " & _
         "({SELECT * FROM Titles " & _
         "WHERE PubID = ?} AS Books " & _
         "RELATE 'PubID' to PARAMETER 0)"
      
      Me.Refresh
      lStart = GetTickCount
      .Open
      txtTime(iU_CONSTRAINED).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      lCount = 0
      While Not .EOF
         Dim lTemp As Long
         vChildSet = .Fields("Books")
         If Not vChildSet.EOF Then
            vChildSet.MoveLast
            lCount = lCount + vChildSet.RecordCount
         End If
         .MoveNext
      Wend
      txtTime(iU_CONSTRAINED + iOFFSET_TOTAL).Text = Format$(((GetTickCount - lStart) / 1000), "##.###")
      txtUnconstrained(iPARENT_CONSTRAINED).Text = lCount
      .Close
   End With
      
   Set oRS = Nothing
   Set oConnect = Nothing
   
   Screen.MousePointer = vbDefault
   
   'NOTES:
   
   '1) Because the count of the child records for both the unconstrained
   '   and constrained SHAPE queries match the total for the conventional
   '   JOIN query, we can feel confident these queries both return accurate
   '   results.  (You can verify that all versions of the constrained SHAPE
   '   queries return accurate results by moving the code which counts the
   '   child records to the appropriate query.)
   '2) The unconstrained SHAPE query takes significantly longer to execute than
   '   the constrained queries.  This is because the child query, being unconstrained,
   '   it returns ALL the rows for the child table even though it is only going
   '   to usse a small number of these rows matching the parent query.
   '3) Notice the queries with an unconstrained child query take the almost
   '   the same amount of time whether or not the parent query is constrained,
   '   further evidence it returns all child rows in all cases
   '4) Also notice the large discrepency between the query time and the total
   '   time (scrolling through and counting child records) for the parameterized
   '   child queries, whereas the other queries take very little time counting
   '   the child records.  Unlike the unparameterized queries, the parameterized
   '   child query will not execute unless and until the child recordset is
   '   accessed.  (Try commenting out all the code in the While Not .EOF loop
   '   except the move next.)  This also means a SEPARATE query is executed for
   '   each child recordset accessed.  If you are accessing a lot of child
   '   recordsets, this makes for a very poor performance.
   
End Sub

Private Sub cmdClose_Click()
   Unload Me
End Sub

Private Sub cmdRequery_Click()
   QueryData
End Sub

Private Sub Form_Load()
   QueryData
End Sub

